/******************************************************************************
* File Name: main.c
*
* Version: 1.10
*
* Description: This is the source code for the Blinking LED code example.
*
* Related Document: CE195352_PSoC_5LP_Blinking_LED.pdf
*
* Hardware Dependency: See CE195352_PSoC_5LP_Blinking_LED.pdf
*
*******************************************************************************
* Copyright (2018), Cypress Semiconductor Corporation. All rights reserved.
*******************************************************************************
* This software, including source code, documentation and related materials
* (“Software”), is owned by Cypress Semiconductor Corporation or one of its
* subsidiaries (“Cypress”) and is protected by and subject to worldwide patent
* protection (United States and foreign), United States copyright laws and
* international treaty provisions. Therefore, you may use this Software only
* as provided in the license agreement accompanying the software package from
* which you obtained this Software (“EULA”).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the Software source
* code solely for use in connection with Cypress’s integrated circuit products.
* Any reproduction, modification, translation, compilation, or representation
* of this Software except as specified above is prohibited without the express
* written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO WARRANTY OF ANY KIND, 
* EXPRESS OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED 
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. Cypress 
* reserves the right to make changes to the Software without notice. Cypress 
* does not assume any liability arising out of the application or use of the 
* Software or any product or circuit described in the Software. Cypress does 
* not authorize its products for use in any products where a malfunction or 
* failure of the Cypress product may reasonably be expected to result in 
* significant property damage, injury or death (“High Risk Product”). By 
* including Cypress’s product in a High Risk Product, the manufacturer of such 
* system or application assumes all risk of such use and in doing so agrees to 
* indemnify Cypress against all liability.
*******************************************************************************/

#include <project.h>

/*******************************************************************************
* Function Name: main
********************************************************************************
*
* Summary:
*  The PWM is configured and started in the PWM_1_Start() function.
*  The firmware then enters an idle loop, leaving control of the project
*  to the fixed function PWM peripheral.
*
* Parameters:
*  None.
*
* Return:
*  None.
*
*******************************************************************************/
int main()
{
    /* Prepare components */
    PWM_Start();
    int16 data_pwm;
    int16 data_pwm2;
    
    for (;;)
    {
        for (;;)
        {
            data_pwm = data_pwm +1;
            if (data_pwm >= 1000) {
                break;
                //data_pwm = 0;
            }
            PWM_WriteCompare1(data_pwm);
            data_pwm2 = 1000 - data_pwm;
            PWM_WriteCompare2(data_pwm2); 
        
            CyDelay(2u);
        }
        CyDelay(100u);
        
        for (;;)
        {
            data_pwm = data_pwm -1;
            if (data_pwm < 0) {
                break;
                //data_pwm = 0;
            }
            PWM_WriteCompare1(data_pwm);
            data_pwm2 = 1000 - data_pwm;        
            PWM_WriteCompare2(data_pwm2); 
        
            CyDelay(2u);  
        }
        CyDelay(100u);
    }
}


/* [] END OF FILE */
