/*******************************************************************************
* File Name: Brake_dir_PM.c
* Version 1.80
*
* Description:
*  This file contains the setup, control, and status commands to support 
*  the component operation in the low power mode. 
*
* Note:
*
********************************************************************************
* Copyright 2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#include "Brake_dir.h"

/* Check for removal by optimization */
#if !defined(Brake_dir_Sync_ctrl_reg__REMOVED)

static Brake_dir_BACKUP_STRUCT  Brake_dir_backup = {0u};

    
/*******************************************************************************
* Function Name: Brake_dir_SaveConfig
********************************************************************************
*
* Summary:
*  Saves the control register value.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void Brake_dir_SaveConfig(void) 
{
    Brake_dir_backup.controlState = Brake_dir_Control;
}


/*******************************************************************************
* Function Name: Brake_dir_RestoreConfig
********************************************************************************
*
* Summary:
*  Restores the control register value.
*
* Parameters:
*  None
*
* Return:
*  None
*
*
*******************************************************************************/
void Brake_dir_RestoreConfig(void) 
{
     Brake_dir_Control = Brake_dir_backup.controlState;
}


/*******************************************************************************
* Function Name: Brake_dir_Sleep
********************************************************************************
*
* Summary:
*  Prepares the component for entering the low power mode.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void Brake_dir_Sleep(void) 
{
    Brake_dir_SaveConfig();
}


/*******************************************************************************
* Function Name: Brake_dir_Wakeup
********************************************************************************
*
* Summary:
*  Restores the component after waking up from the low power mode.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void Brake_dir_Wakeup(void)  
{
    Brake_dir_RestoreConfig();
}

#endif /* End check for removal by optimization */


/* [] END OF FILE */
