/*******************************************************************************
* File Name: dig_dir_PM.c
* Version 1.80
*
* Description:
*  This file contains the setup, control, and status commands to support 
*  the component operation in the low power mode. 
*
* Note:
*
********************************************************************************
* Copyright 2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#include "dig_dir.h"

/* Check for removal by optimization */
#if !defined(dig_dir_Sync_ctrl_reg__REMOVED)

static dig_dir_BACKUP_STRUCT  dig_dir_backup = {0u};

    
/*******************************************************************************
* Function Name: dig_dir_SaveConfig
********************************************************************************
*
* Summary:
*  Saves the control register value.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void dig_dir_SaveConfig(void) 
{
    dig_dir_backup.controlState = dig_dir_Control;
}


/*******************************************************************************
* Function Name: dig_dir_RestoreConfig
********************************************************************************
*
* Summary:
*  Restores the control register value.
*
* Parameters:
*  None
*
* Return:
*  None
*
*
*******************************************************************************/
void dig_dir_RestoreConfig(void) 
{
     dig_dir_Control = dig_dir_backup.controlState;
}


/*******************************************************************************
* Function Name: dig_dir_Sleep
********************************************************************************
*
* Summary:
*  Prepares the component for entering the low power mode.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void dig_dir_Sleep(void) 
{
    dig_dir_SaveConfig();
}


/*******************************************************************************
* Function Name: dig_dir_Wakeup
********************************************************************************
*
* Summary:
*  Restores the component after waking up from the low power mode.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void dig_dir_Wakeup(void)  
{
    dig_dir_RestoreConfig();
}

#endif /* End check for removal by optimization */


/* [] END OF FILE */
