/******************************************************************************
* File Name: main.c
* 
* プッシュSW押す毎に明るさを変えます。16段階
* 
* PIN設定
* プッシュSW P2[2]
* 
* LCD
* LCDボード-PSoc5
* SCL-------P0[0]
* SDA-------P15[5]
* VOC-------VDD
* GND-------GND
* 
* LED
* PSoc5     LED DRIVER board
* P0[5]-----SWITCH19
* P0[6]-----SWITCH110
* P0[7]-----SWITCH111
* P1[2]-----SWITCH112
* P15[1]----SWITCH15
* P15[2]----SWITCH16
* P15[3]----SWITCH17
* P15[4]----SWITCH18
* P3[2]-----SWITCH11
* P3[3]-----SWITCH12
* P3[4]-----SWITCH13
* P3[5]-----SWITCH14
* GND-------GND
* 
* 本プログラム及びTopDesingncyschはLED DRIVER boardの120ポート全部に同じ出力をします
* LEDはLED DRIVER boardの何処に繋いでも良いです。
* 
*******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <project.h>

#define LED_OFF 0
#define LED_ON 1
#define LED_ON_VAL  1000		 								// LED ON時の明るさの値
#define LED_MID_VAL 500			 								// LED 中間時の明るさの値
#define LED_OFF_VAL 8			 								// LED OFF時の明るさの値

#define LCD_CHR 1           // Mode - Sending data
#define LCD_CMD 0           // Mode - Sending command
#define I2C_ADDR  0x7F      // I2C device address 0x27
#define LCD_BACKLIGHT  0x08 // On
#define ENABLE 0b00000100   // Enable bit
#define LCD_LINE_1 0x80     // LCD RAM address for the 1st line
#define LCD_LINE_2 0xC0     // LCD RAM address for the 2nd line


int16 led_set_val = LED_ON_VAL;		    				// 設定する明るさ

// *********************************************
// LCD用lcd_toggle_enable
// *********************************************
void lcd_toggle_enable(uint8 bits){
  //# Toggle enable
  I2C_LCD_1_AddrWriteData(I2C_ADDR, (bits | ENABLE));
  I2C_LCD_1_AddrWriteData(I2C_ADDR,(bits & ~ENABLE));
}

// *********************************************
// LCD用lcd_byte
// *********************************************
void lcd_byte(uint8 bits, uint8 mode){
  uint8 bits_high = mode | (bits & 0xF0) | LCD_BACKLIGHT;
  uint8 bits_low = mode | ((bits<<4) & 0xF0) | LCD_BACKLIGHT;
 
  //# High bits
  I2C_LCD_1_AddrWriteData(I2C_ADDR, bits_high);
  lcd_toggle_enable(bits_high);
 
  //# Low bits
  I2C_LCD_1_AddrWriteData(I2C_ADDR, bits_low);
  lcd_toggle_enable(bits_low);
}

// *********************************************
// LCDにデータを表示
// 引数 row    : 表示列 0=上/1=下
//      column : 表示行 0=左端、1=2文字目....
// ********************************************
void I2C_LCD_Position(uint8 row, uint8 column) {
  if(row == 0){
    I2C_LCD_1_SetDDRAM(0x80 + column);
    }
    else{
    I2C_LCD_1_SetDDRAM(0xC0 + column);
  }
}

// *********************************************
// LCD初期化処理（ACM1602)
// *********************************************
void I2C_LCD_Init(void) {
  lcd_byte(0x33,LCD_CMD); // 110011 Initialise
  lcd_byte(0x32,LCD_CMD); // 110010 Initialise
  lcd_byte(0x06,LCD_CMD); // 000110 Cursor move direction
  lcd_byte(0x0C,LCD_CMD); // 001100 Display On,Cursor Off, Blink Off 
  lcd_byte(0x28,LCD_CMD); // 101000 Data length, number of lines, font size
  lcd_byte(0x01,LCD_CMD); // 000001 Clear display
  CyDelay(5u);                                                  //5mS 待機
}


// ****************************
// 1ms毎のタイマー割り込み処理
// (センサー処理用)
// ****************************
CY_ISR(timer_1_isr){

}

// *****************************************************
// 10us毎のタイマー割り込み処理(常に10us毎に入ってくる割り込み)
//  フィードバック電圧の確認からDuty書き出しまで。
// *****************************************************
CY_ISR(timer_2_isr){
}


// ****************************************************************
// LCDに表示
// ****************************************************************
void lcd_disp(uint8 row, uint8 column, char *data) {
    int len = 0;                                            
    int ii = 0;
    // 表示用バッファ
    static char data_buff[2][16] = {{0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20},
                                    {0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20}};

    len = strlen(data);
    // 表示用バッファにデータを格納して記憶しておく
    for( ii=0; ii< len; ii++) {                             // dataを1byteずつ送信する
        if ((column + ii) > 16 ) {
            break;
        }
        data_buff[row][column+ii] = data[ii];
    }
    if (row == 0) {
       lcd_byte(LCD_LINE_1, LCD_CMD);
    }else{
       lcd_byte(LCD_LINE_2, LCD_CMD);
    }
    len = strlen(data);
    for( ii=0; ii< 16; ii++) {                              // dataを1byteずつ送信する
        lcd_byte(data_buff[row][ii],LCD_CHR);
    }
}


// ****************************
//    メインルーチン
// ****************************
int main()
{
    char lcd_buff[17];
    int i=0;

    //Enable global interrupts
    CyGlobalIntEnable;

    /* Prepare components */
    PWM_Start();
    int16 data_pwm;
    int16 data_pwm2;
    
    // LCD Start
    I2C_1_Start();
    CyDelay(10u);                                               // 10ms 待機
    I2C_LCD_Init();
    CyDelay(10u);                                               // 10ms 待機
    
    
    I2C_LCD_1_ClearDisplay();

    // 起動メッセージ
    CyDelay(100u);
    lcd_disp(0u,0u,"Power Start ");
    lcd_disp(1u,0u,"Please wait...");
    CyDelay(100u);
    lcd_disp(0u,0u,"****************");
    lcd_disp(1u,0u,"LED VOL 16      ");
   
     for (;;)
    {
        //　プッシュSWが押されたら
        if (Push_Switch_Read()==0) {
            // プッシュSWが離されるのを待つ
            for(;;) {
                CyDelay(10u);                                   // 10mS 待機
                //　プッシュSWが離されたら
                if (Push_Switch_Read()==1) {
                    // プッシュSW押す毎に明るさを変えます。16段階
                    led_set_val = led_set_val - 62;             // 1000/16=62.5
                    if (led_set_val <= LED_OFF_VAL) {                    
                        led_set_val = LED_ON_VAL;
                    }
                    sprintf(lcd_buff,"");
                    for (i=0;i<led_set_val/62;i++) {
                        sprintf(lcd_buff,"%s*",lcd_buff);
                    }    
                    for (i=0;i<16-(led_set_val/62);i++) {
                        sprintf(lcd_buff,"%s ",lcd_buff);
                    }    
                    lcd_disp(0u,0u,lcd_buff);
                    sprintf(lcd_buff,"LED VOL %2d",led_set_val/62);
                    lcd_disp(1u,0u,lcd_buff);
                    break;                                      // 次に進む
                }
            }
        }
        PWM_WriteCompare1(led_set_val);
        PWM_WriteCompare2(led_set_val); 
        CyDelay(100u);
    }
}


/* [] END OF FILE */
